// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.4-1 Page 766
//Title: Design of memberane unit for complete mixing
//================================================
model Ex13_4_1

//=============
//Parameter section
parameter Real qf(unit = "cm^3") = 10^4 "Feed flow rate";
parameter Real xf(unit = "-") = 0.5 "Feed composition";
parameter Real xo(unit = "-") = 0.25 "Desired composition of reject";
parameter Real t(unit = "cm") = 2.54E-03 "Thickness of the memberane";
parameter Real Ph(unit = "cmHg") = 80 "Pressure in feed side";
parameter Real Pl(unit = "cmHg") = 20 "Pressure on the permeate side";
parameter Real Pa(unit = "cm^3.cm/s.cm^2.cmHg") = 50E-10 "Permeablity on the A";
parameter Real Pb(unit = "cm^3.cm/s.cm^2.cmHg") = 5E-10 "Permeablity on the B";

//=============
//Variable section
Real alpha(unit = "-") "Ratio of permeablities";
Real a(unit = "-") "Quadratic equation constant";
Real b(unit = "-") "Quadratic equation constant";
Real c(unit = "-") "Quadratic equation constant";
Real y(unit = "-") "Permeate composition";
Real teta(unit = "-") "Fraction permeated";
Real Am(unit = "cm^2") "Area required";

//=============
//Equation section
equation
alpha = Pa/Pb ; // Ratio of permeablities
a = 1 - alpha ; //Quadratic equation constant
b = (Ph/Pl)*(1-xo) - 1 + alpha*(Ph/Pl)*xo + alpha ; //Quadratic equation constant
c = -alpha*(Ph/Pl)*xo ; // Quadratic equation constant
y = (-b + sqrt(b^2 - 4*a*c))/(2*a) ; // Permeate composition
xo = (xf-teta*y)/(1-teta) ; // Mass balance equation
Am = (teta*qf*y)/((Pa/t)*(Ph*xo - Pl*y)) ; // Areq required
end Ex13_4_1;
//===============================================
