// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.4-3 Page 769
//Title: Effect of feed composition on minimum reject composition
//================================================
model Ex13_4_3

//=============
//Parameter section
parameter Real xf_1(unit = "-") = 0.5 "Feed composition case 1";
parameter Real xf_2(unit = "-") = 0.65 "Feed composition case 2";
parameter Real xo(unit = "-") = 0.25 "Desired composition of reject";
parameter Real Ph(unit = "cmHg") = 80 "Pressure in feed side";
parameter Real Pl(unit = "cmHg") = 20 "Pressure on the permeate side";
parameter Real Pa(unit = "cm^3.cm/s.cm^2.cmHg") = 50E-10 "Permeablity on the A";
parameter Real Pb(unit = "cm^3.cm/s.cm^2.cmHg") = 5E-10 "Permeablity on the B";
parameter Real alpha(unit = "-") = 10 "Ratio of permeablities";

//=============
//Variable section
Real xom1(unit = "-") "Minimum reject composition for case 1";
Real xom2(unit = "-") "Minimum reject composition for case 2";

//============
//Equation section
equation
xom1 = (xf_1*(1+(alpha-1)*(Pl/Ph)*(1-xf_1)))/(alpha*(1-xf_1)+xf_1) ; // Minimum reject composition for case 1
xom2 = (xf_2*(1+(alpha-1)*(Pl/Ph)*(1-xf_2)))/(alpha*(1-xf_2)+xf_2) ; // Minimum reject composition for case 2
end Ex13_4_3;
//==============================================
