// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-13: Memberane seperation process
//Example 13.5-1 Page 771
//Title: Design of memberane units for multicomponent mixtures
//=====================================================
model Ex13_5_1

//==============
//Parameter section
parameter Real xfa(unit = "-") = 0.25 "Composition of solute A";
parameter Real xfb(unit = "-") = 0.55 "Composition of solute B";
parameter Real xfc(unit = "-") = 0.20 "Composition of solute C";
parameter Real t(unit = "cm") = 2.54E-03 "Thickness of the memberane";
parameter Real Ph(unit = "cmHg") = 300 "Pressure in feed side";
parameter Real Pl(unit = "cmHg") = 20 "Pressure on the permeate side";
parameter Real qf(unit = "cm^3") = 10^4 "Feed flow rate";
parameter Real Pa(unit = "cm^3.cm/s.cm^2.cmHg") = 200E-10 "Permeablity on the A";
parameter Real Pb(unit = "cm^3.cm/s.cm^2.cmHg") = 50E-10 "Permeablity on the B";
parameter Real Pc(unit = "cm^3.cm/s.cm^2.cmHg") = 25E-10 "Permeablity on the B";
parameter Real teta(unit = "-") = 0.25 "Fraction of permeate";
parameter Real ypA(unit = "-") = 0.45 "Composition of permeate of solute A";

//The problem involves trail and error method, and it is directly done from the second iteration

//==============
//Variable section
Real qp(unit = "cm^3") "Flow rate of permeate";
Real Am(unit = "cm^2") "Area of memberane";
Real ypB(unit = "-") "Composition of permeate of solute B";
Real ypC(unit = "-") "Composition of permeate of solute B";
Real xoA(unit = "-") "Reject composition of solute A";
Real xoB(unit = "-") "Reject composition of solute B";
Real xoC(unit = "-") "Reject composition of solute C";

//==============
//Equation section
equation
qp = teta*qf ; // Flow rate in permeate
Am = (qp*ypA*t)/(Pa*((Ph/(1-teta))*(xfa-teta*ypA)-Pl*ypA)) ; // Area of mmberane
ypB = (Ph*xfb/(1-teta))/((qp*t/(Pb*Am)) + (teta*Ph/(1-teta)) + Pl) ; // Composition of perameate B;
ypC = (Ph*xfc/(1-teta))/((qp*t/(Pc*Am)) + (teta*Ph/(1-teta)) + Pl) ; // Composition of perameate B;
xoA = (xfa/(1-teta)) - (teta*ypA/(1-teta)); // Reject Composition of A
xoB = (xfb/(1-teta)) - (teta*ypB/(1-teta)); // Reject Composition of B
xoC = (xfc/(1-teta)) - (teta*ypC/(1-teta)); // Reject Composition of C
end Ex13_5_1;
//======================================================
