// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.2-2 Page 811
//Title: Time required to perform filtration
//================================================
model Ex14_2_2

//===============
//Parameter section
parameter Real n(unit ="-") = 20 "Number of filter presses";
parameter Real A(unit = "m^2") = 0.873 "Area of 1 frame";
parameter Real A_filter(unit = "m^2") = 0.0439 "Area of filter";
parameter Real v(unit = "m^3") = 3.37 "Volume of filtrate to be recovered";
parameter Real Kp(unit = "s/m^6") = 6E06 "Slope obtained by plotting the given data";
parameter Real B(unit = "s/m^3") = 6400 "Intercept from the given data";

//===============
//Variable section
Real Kp_new(unit = "s/m^6") "Slope obtained by plotting the given data";
Real B_new(unit = "s/m^3") "Intercept from plotting data points";
Real A_new(unit = "m^2") "New area for using 20 frames";
Real t(unit = "s") "Time required for filtration";

//===============
//Equation section
equation
A_new = n*A ; // Area for 20 frames
Kp_new = Kp*(A_filter/A_new)^2; // New Kp calculated for 20 frames of filter
B_new = B*(A_filter/A_new) ; // New intercept for 20 frames of filter
t = (Kp_new/2)*v^2 + B_new*v ; // Time required for filtration
end Ex14_2_2;
//===================================================
