// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.3-1 Page 818
//Title: Settling velocity of oil droplets
//================================================
model Ex14_3_1

//===============
//Parameter section
parameter Real D(unit = "m") = 0.02E-03 "Diameter of droplet";
   // 10^-3 is multiplied to convert mm to m
parameter Real rho(unit = "kg/m^3") = 900 "Density of fluid";
parameter Real mu(unit = "Pa.s") = 1.9E-05 "Viscosity of particle";
parameter Real rhop(unit = "kg/m^3") = 1.137 "Density of fluid";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//==============
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real v(unit = "m/s")"velocity of oil droplet";
Real cd(unit = "-") "Drag coefficient";

//===============
//Equation section
equation
NRe = D*rhop*v/(mu) ; // Reynolds number
cd = 0.2067/v^2 ; // Drag coefficient
v = -g*D^2*(rhop-rho)/(18*mu) ; // Velocity
  // The negative sign taken for sign convention since the particle is moving downwards
end Ex14_3_1;
//================================================
