// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.3-2 Page 820
//Title: Hindered settling of glass sphere
//================================================
model Ex14_3_2

//==============
//Parameter section
parameter Real D(unit = "m") = 1.554E-04 "Dimameter of the particle";
parameter Real rho_p(unit = "kg/m^3") = 2467 "Density of the sphere";
parameter Real rho(unit = "kg/m^3") = 998 "Density of the water";
parameter Real mu(unit = "Pa.s") = 1.005E-03 "Viscosity of the fluid"; 
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//==============
//Variable section
Real epslon(unit = "-") "Volume fraction of the liquid";
Real rho_m(unit = "kg/m^3") "Bulk density of mixture";
Real si(unit = "-") "Emperical correction factor";
Real v(unit = "m/s") "Terminal velocity of glass sphere";
Real NRe(unit = "-") "Reynolds number of the particle";

//==============
//Equation section
equation
epslon = (40/rho)/((40/rho)+(60/rho_p)) ;// Void fraction of liquid
rho_m = epslon*rho + (1-epslon)*rho_p ; // Bulk density of mixture
si = 1/(10^(1.82*(1-epslon))) ; // Emperical correlation factor
v = (g*D^2*(rho_p-rho)*epslon^2*si)/(18*mu) ; // Terminal velocity of the liquid
NRe = (D*v*rho_m)/((mu*epslon/si)) ; // Reynolds number
end Ex14_3_2;
//============================================================
