// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.4-3 Page 836
//Title: Location of interface in centrifuge
//================================================
model Ex14_4_3

//=============
//Parameter section
parameter Real rho_l(unit = "kg/m^3") = 919.5 "Density of oil";
parameter Real rho_h(unit = "kg/m^3") = 980.5 "Density of aquous phase";
parameter Real r1(unit = "mm") = 10.16 "Inner radius of the bowl";
parameter Real r2(unit = "mm") = 10.414 "Inner radius of the bowl";

//=============
//Variable section
Real ri(unit = "mm") "Location of inetrface in the centrifuge";

//==============
//Equation
equation
ri^2 = (rho_h*r2^2 - rho_l*r1^2)/(rho_h - rho_l) ; // Interface between outer and inner diameter
end Ex14_4_3;
//==========================================================
