// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-14: Mechanical-Physical separation processes
//Example 14.5-1 Page 843
//Title: Power to crush iron ore by bonds theory
//================================================
model Ex14_5_1

//=============
//Parameter section
parameter Real T(unit = "Tons/hr") = 10 "Mass flow rate fed into the crusher";
parameter Real Ei(unit = "-") = 12.68 "Work required to reduce the soilf from initial to final size";
parameter Real Dp(unit = "inches") = 1/8 "Final particle size";
parameter Real Df(unit = "inches") = 3 "Initial particle size";

//=============
//Variable section
Real P(unit = "hp") "Power required to crush the iron ore";

//==============
//Equation section
equation
(P/(T/60)) = 1.46*Ei*((1/sqrt(1/(8*12))) - (1/sqrt(3/12))) ;
  // T is divided by 60 to convert tonnes per hour to tonnes per second
  // The particle sie is divided by 12 to convert inches to ft
end Ex14_5_1;
//==================================================
