// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.10-3 Page 89
//Title: Using friction factor for turbulent flow
//================================================
model Ex2_10_3

//=============
//Parameter section
parameter Real D(unit = "m") = 0.0525 "Diameter of the pipe";
parameter Real rho(unit = "kg/m^3") = 810 "Density of fluid";
parameter Real V(unit = "m/s") = 4.57 "Velocity of fluid";
parameter Real mu(unit = "Pa.s") = 4.46E-03 "Viscosity of fluid";
parameter Real L(unit = "m") = 36.6 "Length of the section";
parameter Real epslon(unit = "m") = 4.6E-05 "Roughness of pipe" ; 
parameter Real f(unit = "-") = 0.006 "Friction factor";

//=============
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real F(unit = "J/kg") "Friction losses";
Real rough(unit = "-") "Roughness parameter";

//=============
//Equation section
equation
NRe = (D * rho * V )/ mu ; // Reynolds number 
rough = epslon/D ; // Roughness parameter of pipe
F= f*4*(V^2/2)*(L/D) ; // Frictional losses
end Ex2_10_3;
//===========================================
