// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.10-8 Page 100
//Title: Entrance length of fluid in a pump
//================================================
model Ex2_10_8

//=============
//Parameter section
parameter Real mu(unit = "kg/m.s") = 1.005E-03 "Viscosity of fluid";
parameter Real rho(unit = "kg/m^3") = 998.2 "Density of fluid";
parameter Real D(unit = "m") = 0.01 "diameter of pipe";
parameter Real V(unit = "m/s") = 0.10 "Velocity of fluid";

//=============
//Variable section
Real NRe(unit = "-") "Reynold number";
Real Le_laminar(unit = "m") "Entrance lemgth in laminar flow";
Real Le_turblent(unit = "m") "Entrance lemgth in turblent flow";

//==============
//Equation section
equation
NRe =(D*rho*V)/mu ; //Reynolds number
Le_laminar/D = 0.0575*NRe; // Entrance length of pipe
Le_turblent = 50*D ; // Entrance length for turblent flow
end Ex2_10_8;
//==================================================
