// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.2-3 Page 36
//Title: Converting pressure to head of fluid
//================================================
model Ex2_2_3

//================
//Parameter Section
parameter Real P(unit = "kN/m^2") = 101.325 "Pressure of the system";
parameter Real Rho_water(unit = "kg/m^3") = 1000 "Density of water";
parameter Real Rho_Hg(unit = "g/cm^3") = 13.5955 "Density of mercury";
parameter Real g(unit = "m/s^2") = 9.80665 "Acc due to gravity";

//================
//Variable Section
Real h(unit = "m") "Head of water in meters";
Real hHg(unit = "m Hg") "Head of water in mmHg";

//================
//Equation Section
equation
h = (P*10^3)/(Rho_water*g); //Head of water
hHg = h*((Rho_water/1000)/Rho_Hg); //Head of Mercury
         // P is multiplied by 10^3 to convert kN/m^2 to N/m^2
         // Rho_water is divided by 10^3 to convert mmHg to mHg
end Ex2_2_3;
//==================================================
