// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.4-1 Page 45
//Title: Calculation of shear stress of liquid
//================================================
model Ex2_4_1

//==============
//Parameter section
parameter Real delv(unit = "cm/s") = 10 "Change in velocity";
parameter Real dely(unit = "cm") = 0.5 "Distance btw the plates";
parameter Real mu(unit = "g/cm.s") = 0.0177 "Viscosity of the fluid";

//==============
//Varialbe section
Real tou_cgs(unit = "dyne/cm^2") "Shear stress in cgs units";
Real tou_english(unit = "lbf/ft^2") "Shaer stress in English units";
Real tou_SI(unit = "N/m^2") "Shaer stress in SI units";
Real shear_rate(unit = "s^-1") "Rate of shear";

//==============
//Equation
equation
tou_cgs = mu*(delv/dely); //Shear stress in cgs units
tou_english = (mu/32.174)*(6.7197E-02)*(delv/dely); //Shaer stress in English units
 // 32.174 is gravitational correction factor
 // 6.7197E-02 is multiplied to convert g/cm.s to lb/ft.s
tou_SI = (mu/10)*((delv/100)/(dely/100)); //Shaer stress in SI units"
 // mu is divided by 10 to convert it to Pa.s 
shear_rate = delv/dely ; 
end Ex2_4_1;
//=====================================================
