// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.5-1 Page 49
//Title: Reynolds number in pipe
//================================================
model Ex2_5_1

//===============
// Libraries 
extends Modelica.Constants;

//================
//Parameter section
parameter Real D_in(unit = "ft") = 2.067  "Diameter of pipe";
parameter Real Q_gal(unit = "ft^3/s") = 10 "Voluetric flow rate";
parameter Real rho_fts(unit = "lbm/ft^3") = (0.996*62.43) "Density of fluid";
parameter Real mu_fts(unit = "lbm/ft.s") = 5.38E-04 "Viscosity of fluid";
parameter Real rho_si(unit = "kg/m^3") = (0.996*1000) "Density of fluid";
parameter Real mu_si(unit = "kg/m.s") = 8.007E-04 "Viscosity of fluid";

//===============
//Variable section
Real D(unit = "ft") "Diameter of pipe";
Real A(unit = "ft^2") "Area of pipe";
Real Q(unit = "ft^3/s") "Volumetric flow rate";
Real V(unit = "ft/s") "Velocity of fluid";
Real Re_1(unit = "-") "Reynolds number in FTS system of units";
Real Re_2(unit = "-") "Reynolds number in SI system of units";
Real D_si(unit = "ft") "Diameter of pipe";
Real V_si(unit = "ft/s") "Velocity of fluid";

//================
//Equation section
equation
Q = Q_gal/(7.481*60) ; //Flow rate of fluid
  // Q is divided by 7.481 to convert gallons to ft^3
  // Q is divided by 60 to convert min to S
D = D_in/12 ; //Diameter of pipe
  // It is divided by 12 to convert inches to ft
A = (pi/4)*(D^2) ; //Area of pipe
V = Q/A ; // Velocity of fluid
Re_1 = D*rho_fts*V/mu_fts ; //Reynolds number
D_si = D_in/(12*3.2808) ; //Diameter in SI units
  // It is divided by 12 to convert inches to ft
  // D is divided by 3.2808 to convert ft to m
V_si = V/3.2808 ; //Velocity in SI units
Re_2 = D_si*rho_si*V_si/mu_si ; //Reynolds number using SI system
end Ex2_5_1;
//===============================================
