// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.7-1 Page 61
//Title: Energy balance in steam boiler
//================================================
model Ex2_7_1

//==============
//Parameter section
parameter Real H1(unit = "kJ/kg") = 76.97 "Enthalpy at temperature at 18.33 C";
parameter Real H2(unit = "kJ/kg") = 2771.4 "Enthalpy at temperature at 148.9 C";
parameter Real V1(unit = "m/s") = 1.52 "Velocity at section 1";
parameter Real V2(unit = "m/s") = 9.41 "Velocity at section 2";
parameter Real z1(unit = "m") = 0 "Height of section 1";
parameter Real z2(unit = "m") = 9.14 "Height of section 2";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

// The enthalpy values are taken from appendix A.2

//==============
//Variable section
Real Q(unit = "J/kg") "Heat added per kg of steam";

//==============
//Equation section
equation
Q = (z2 - z2)*g + (V2^2 - V1^2)/2 + (H2-H1)*1000 ; // Heat added to the system
     // 1000 is multiplied to convert kJ to J
end Ex2_7_1;
//===================================================
