// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.7-5 Page 65
//Title: Pump horse power in flow system
//================================================
model Ex2_7_5

//===============
//Parameter section
parameter Real Q_gal(unit = "gal/min") = 69.1 "Volumetric flow rate";
parameter Real rho(unit = "lbm/ft^3") = 114.8 "Density of fluid";
parameter Real A3(unit = "ft^2") = 0.05134 "Area of section 3";
parameter Real A2(unit = "ft^2") = 0.0233 "Area of section 2";
parameter Real z1(unit = "ft") = 0 "Height of section 1";
parameter Real z2(unit  = "ft") = 50 "Height of section 2";
parameter Real z3(unit  = "ft") = 0 "Height of section 3";
parameter Real z4(unit  = "ft") = 0 "Height of section 4";
parameter Real pressure_head(unit = "ft.lbf/lbm") = 0 "Pressure head";
parameter Real gc(unit = " lbm.ft/lbf.s^2") = 32.174 "Gravitational correction for FTS system";
parameter Real F(unit = "ft.lbf/lbm") = 10 "Frictional losses";
parameter Real eff(unit = "-") = 0.65 "Effeciency of pump";

//==============
//Variable section
Real Q(unit = "ft^3/s") "Volumetric flow rate";
Real v2(unit = "ft/s") "Velocity at section 2";
Real vel_head(unit = "ft.lbf/lbm") "Velocity head";
Real potential_head(unit  = "ft.lbf/lbm") "Potential head";
Real Wp(unit = "ft.lbf/lbm") "Shaft work";
Real Ws(unit = "ft.lbf/lbm") "Overall work";
Real hp(unit = "hp") "Horse power";
Real M(unit = "lbm/s") "Mass flow rate";
Real v3(unit = "ft/s") "Velocity at section 3";
Real v4(unit = "ft/s") "Velocity at section 4";
Real DeltaP(unit = "lbf/in^2") "Difference in pressure btw section 3 and 4";

//================
//Equation section
equation
Q = Q_gal/(60*7.481); // Volumetric flow rate of fluid
       // Q is divided by 60 to convert min to sec
       // Q is divided by 7.481 to convert gal to ft^3
v2 = Q/A2  ; // velocity at section 2
vel_head = v2^2/(2*gc) ; //Velocity head
potential_head = z2*gc/gc ; //Potential head
Ws = z1*gc/gc - potential_head - vel_head + pressure_head - F ; //Shaft work
Wp = -Ws/eff ; // Overall work
M = Q*rho ; // Mass flow rate
hp = M*Wp/550 ; // Horse power of pump
     // hp is divided by 550 to cinvert ft.lbf/s to hp
v3 = Q/A3 ; //Velocity of fluid in section 3
v4 = v2; // Velocity of section 4 
DeltaP = ((z3 - z4)*(gc/gc) + (v3^2 - v4^2)/(2*gc) - Ws)*(rho/144); // Difference in pressure btw section 3 and 4
      // DelP is divided by 144 to convert to lbf/in^2
end Ex2_7_5;
//=====================================================
