// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.8-2 Page 72
//Title: Momentum balance for horizontal nozzle
//================================================
model Ex2_8_2

//===============
// Libraries 
extends Modelica.Constants;

//================
//Parameter section
parameter Real Q(unit = "m^3/s") = 0.03154 "Volumetric flow rate";
parameter Real d1(unit = "m") = 0.0635 "Diameter at section 1";
parameter Real d2(unit = "m") = 0.0286 "Diameter at section 2";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of the fluid";
parameter Real P2(unit = "kN/m^2") = 0 "pressure of section 2";

//===============
//Variable section
Real A1(unit = "m^2") "Area of section 1";
Real A2(unit = "m^2") "Area of section 2";
Real M(unit = "kg/s") "Mass flow rate";
Real P1(unit = "kN/m^2") "Pressure at section 1";
Real v1(unit = "m/s") "Velocity in section 1";
Real v2(unit = "m/s") "Velocity in section 2";
Real Rx(unit = "N") "Momentum in x direction";

//================
//Equation section
equation
A1 = (pi/4)*d1^2 ; //Area of section 1
A2 = (pi/4)*d2^2 ; //Area of section 2
M = Q*rho ; //Mass flow rate
v1 = Q/A1 ; // Velocity at section 1
v2 = Q/A2 ; // Velocity at section 2
v1^2/2 + P1/rho = v2^2/2 + P2/rho ; // Pressure at section 1
Rx = M*(v2 - v1) + P2*A2 - P1*A1 ; // Momentum balance equation in x direction
end Ex2_8_2;
//============================================
