// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.8-5 Page 76
//Title: Force of free jet on curved fixed plane
//================================================
model Ex2_8_5

//===============
// Libraries 
extends Modelica.Constants;

//=================
//Parameter section
parameter Real v(unit = "m/s") = 30.5 "Velocity of the flowing fluid";
parameter Real d(unit = "m") = 2.54E-02 "Diameter of curved section";
parameter Real alpha2(unit = "degree") = 60 "Angle deflected in the curved vane";
parameter Real rho(unit = "kg/m^3") = 1000 "Density of the fluid";

//=================
//Variable section
Real A1(unit = "m^2") "Area of section 1";
Real M(unit = "kg/s") "Mass flow rate";
Real Rx(unit = "N") "Momentum in x direction";
Real Ry(unit = "N") "Momentum in y direction";

//=================
//Equation section
equation
A1 = (pi/4)*d^2 ; //Area of section 1
M = rho*v*A1 ; //Mass flow rate, equation of continuity
Rx = M*v*(cos(pi/3) - 1) ; // Momentum in x direction
Ry = M*v* sin(pi/3) ; // Momentum in y direction
end Ex2_8_5;
//======================================================
