// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-2: Principles of Momentum Trsnsfer and Overall Balances 
//Example 2.9-1 Page 82
//Title: Falling film thickness and velocity
//================================================
model Ex2_9_1

//============
//Parameter section
parameter Real del(unit = "m") = 0.0017 "Tickness of film";
parameter Real rho(unit = "kg/m^3") = 820 "Density of oil";
parameter Real mu(unit = "Pa.s") = 0.2 "Viscosity of oil";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//============
//Variable section
Real T(unit = "kg/s.m") "Mass flow per width of wall";
Real V(unit = "m/s") "Velocity of falling film";
Real NRe(unit = "-") "Reynolds number of film";

//=============
//Equation section
equation
T = (rho^2 * del^3 * g)/(3*mu) ; // Thickness of film
NRe = 4*T/mu ; // Reynolds number of film
V = (rho * g * del^2)/(3*mu) ; // Velocity of falling film
end Ex2_9_1;
//======================================================
