// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.1.-1 Page 117
//Title: Force on Submerged Sphere
//================================================
model Ex3_1_1
//===============
// Libraries 
extends Modelica.Constants;

//============
//Parameter section
parameter Real dp(unit = "m") = 0.042 "Diameter of particle";
parameter Real v(unit = "m/s") = 23 "Veloctity of flow";
parameter Real cd(unit = "-") = 0.47 "Drag coefficient";
parameter Real rho(unit = "kg/m^3") = 1.137 "Density of air";
parameter Real mu(unit = "kg/m.s") = 1.9E-05 "Viscosity of the fluid";

//============
//Variable section
Real NRe(unit = "-") "Reynolds number";
Real FD(unit = "N") "Drag force";

//============
// Equation section
equation
NRe = (dp*rho*v)/mu ; // Reynolds number of the fluid
FD = cd*(v^2/2)*rho*(pi/4)*dp^2 ; // Drag coefficient of the fluid
end Ex3_1_1;
//================================================
