// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.1-7 Page 126
//Title: Expansion of bed
//================================================
model Ex3_1_7

//==============
//Parameter section
parameter Real NRe(unit = "-") = 0.07764 "Reynolds number at minimum fluidisation";
parameter Real vmf(unit = "m/s") = 0.005029 "Minimum fluidistion velocity";
parameter Real epslonmf(unit = "-") = 0.42 "voidage at minimum fluidisation";

//=============
//Variable section
Real vt(unit = "m/s") "Maximum possible velocity";
Real v(unit = "m/s") "Allowable velocity";
Real K1(unit = "-") "Constant";
Real epslon(unit = "-") "void fraction";

//===============
//Equation section
equation
vt = 90*vmf ; // Maximum possible velocity"
v = 3*vmf ; //Actual operating velocity"
vmf = K1 * (epslonmf^3)/(1-epslonmf) ; // Constant 
v = K1 * (epslon^3)/(1-epslon) ; // Void fraction
end Ex3_1_7;
//=================================================
