// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.2-2 Page 132
//Title: Metering of oil flow by orifice meter
//================================================
model Ex3_2_2

//===============
// Libraries 
extends Modelica.Constants;

//=============
//Parameter section
parameter Real Di(unit = "m") = 0.0566 "Diameter of throat";
parameter Real Do(unit = "m") = 0.1541 "Diameter of Pipe";
parameter Real Deltap(unit = "kPa") = 93.2 "Pressure drop";
parameter Real cd(unit = "-") = 0.61 "Discharge coefficient";
parameter Real mu(unit = "Pa.s") = 4.1E-03 "Viscosity of oil";
parameter Real rho(unit = "kg/m^3") = 878 "Density of fluid";

//===============
//Variable section
Real vo(unit = "m/s") "Veloctiy of the fluid";
Real beta(unit = "-") "Ratio of diameters";
Real Q(unit  = "m^3/s") "Volumetric flow rate of he fluid";
Real NRe(unit = "-") "Reynolds number of the fluid";

//==============
//Equation section
equation
beta = (Di/Do) ; // Ratio of diameters
vo = (cd*sqrt(2*Deltap*10^3/rho)/(sqrt(1-beta^4))) ; // Velocity of flowing fluid
Q = vo*(pi/4)*Di^2 ; // Flowrate of the fluid
NRe = Di*vo*rho/mu ; // Reynolds number
end Ex3_2_2;
//================================================
