// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.3-3 Page 140
//Title: Compression of Methane
//================================================
model Ex3_3_3

//=============
//Parameter section
parameter Real f(unit = "kmol/s") = 7.56E-03 "Molar flow rate of the gas";
parameter Real MW(unit = "kg/kmol") = 16 "Molecular weight of gas";
parameter Real gamma(unit = "-") = 1.31 "Gamma";
parameter Real p1(unit = "kPa") = 137.9 "Initial pressure";
parameter Real p2(unit = "kPa") = 551.6 "Final pressure";
parameter Real R(unit = "J/kmol.K") = 8314.33 "Universal gas constant";
parameter Real T(unit = "K") = 299.9 "Operating temperature";
parameter Real eff(unit = "-") = 80 "Effeciency of compression";

//=============
//Variable section
Real M(unit = "kg/s") "Mass flow rate of the fluid";
Real Ws1(unit = "J/kg") "Shaft work";
Real Ws2(unit = "J/kg") "Shaft work";
Real break_hp1(unit = "kW") "Break horse power";
Real break_hp2(unit = "kW") "Break horse power";

//================
//Equation section
equation
M = f*MW ; // Mass flow rate
-Ws1 = (gamma/(gamma-1))*(R*T/MW)*((p2/p1)^((gamma-1)/gamma) - 1) ; // Work done for compression
break_hp1 = -Ws1*M/((eff/100)*1000) ; // Break horse power in 1
-Ws2 = (2.3026*R*T/MW) * log10(p2/p1) ; // Work done in second case
break_hp2 = -Ws2*M/((eff/100)*1000) ; // Break horse power in 2
end Ex3_3_3;
//===============================================
