// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-3: Flow past immersed objects and packed and fluidised bed
//Example 3.5-1 Page 158
//Title: Pressure drop of a power law fluid in laminar flow
//================================================
model Ex3_5_1

//=============
//Parameter section
parameter Real rho(unit = "kg.m^3") = 1041 "Density of the fluid";
parameter Real L(unit = "m") = 14.9 "Length of the tube";
parameter Real d(unit = "m") = 0.0524 "Diameter of the tube";
parameter Real v(unit = "m/s") = 0.0728 "Velocity of the fluid";
parameter Real K(unit = "Ns/m^2") = 15.23 "Rheological property";
parameter Real n(unit = "-") = 0.4 "Rhelogical properties";

//=============
//Variable section
Real Deltap(unit = "Pa") "Pressure drop";
Real F(unit = "J/kg") "Friction losses";
Real NRe(unit = "-") "Reynolds number";
Real f(unit = "-") "Friction factor";
Real Deltap2(unit = "kPa") "Pressure drop in case 2";

//==============
//Equation section
equation
Deltap = ((K*4*L/d)*(8*v/d)^n) ; // Pressure drop
   // It is divided to convert Pa to kPa
F = Deltap/rho ; // Friction loss
NRe = (d^n * v^(2-n) * rho)/(K*8^(n-1)) ; // Reynolds number
f = 16/NRe ; // Friction factor
Deltap2 = 4*f*rho*(L/d)*(v^2)/(2*1000) ; // Pressure drop in second case
   // It is divided to convert Pa to kPa
end Ex3_5_1;
//================================================
