// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.1-1 Page 217
//Title: Heat loss through an insulating wall
//================================================
model Ex4_1_1

//===============
//Parameter section
parameter Real delx(unit = "mm") = 25.4 "Thickness of the wall";
parameter Real k(unit = "W/m.K") = 0.048 "Thermal conductivity";
parameter Real T1(unit = "K") = 352.7 "Inside temperature of the wall";
parameter Real T2(unit = "K") = 297.1 "Outside temperature of the wall";

//===============
//Variable section
Real Q_SI(unit = "W/m^2") "Heat transfer flux";
Real Q_eng(unit = "BTU/h.ft^2") "Heat transfer flux";

//===============
//Equation section
equation
Q_SI = k*(T1-T2)/(delx/1000) ; // Heat transfer flux
 // It is divided by 1000 to convert mm to m
Q_eng = Q_SI/3.1546 ; // Heat transfer flux in english units
 // It is divided by 3.1546 t convert W/m^2 to BTU/h.ft^2
end Ex4_1_1;
//=================================================
