// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.10-1 Page 279
//Title: Radiation to a metal tube 
//================================================
model Ex4_10_1

//===============
// Libraries 
extends Modelica.Constants;

//================
//Parameter section
parameter Real D(unit = "m") = 0.0254 "Outer diameter of the tube";
parameter Real L(unit = "m") = 0.61 "Length of the tube";
parameter Real epslon(unit = "-") = 0.6 "Emissivity of the metal tube";
parameter Real T1(unit = "K") = 588 "cold end temperature";
parameter Real T2(unit = "K") = 1088 "Hot end temperature";
parameter Real sigma(unit = "K^4/m^2.W") = 5.676E-08 "Stephen boltzmen constant";

//=================
//Variable section
Real A(unit = "m^2") "Area required for heat transfer";
Real q(unit = "W") "Amount of heat transfer";

//=================
//Equation section
equation
A = pi*D*L ; // Area required
q = A*epslon*sigma*(T1^4-T2^4) ; // Amount of heat transferred
end Ex4_10_1;
//====================================================
