// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.13-1 Page 301
//Title: Heat transfer coefficient in agitated vessel with jacket
//================================================
model Ex4_13_1

//================
//Parameter section
parameter Real Dt(unit = "m") = 1.83 "Diameter of the tube";
parameter Real Da(unit = "m") = 0.61 "Diameter of the agitator";
parameter Real rho(unit = "kg/m^3") = 961 "Density of the fluid";
parameter Real mu(unit = "Pa.s") = 1 "Viscosity of the fluid";
parameter Real muw(unit = "Pa.s") = 0.084 "Viscosity at reduced temperature";
parameter Real k(unit = "W/m.K") = 0.173 "Thermal conductivity of the fluid";
parameter Real Cp(unit = "kJ/kg.K") = 2.5 "Specific heat cpacity";
parameter Real N(unit = "Rev/min") = 100 "Number of revolutions per minute";

//================
//Variable section
Real NRe(unit = "-") "Reynolds number of the fluid";
Real Npr(unit = "-") "Prandle number of the fluid";
Real hL(unit = "W/m^2.K") "Heat transfer coefficient";

//================
//Equation section
equation
NRe = Da^2*(N/60)*rho/mu ; // Reynolds number of the tube
Npr = Cp*1000*mu/k ; // Prandle number
hL*Dt/k = 0.75*NRe^(2/3)*Npr^(1/3)*(mu/muw)^0.14 ; // Heat transfer coefficient
end Ex4_13_1;
//==================================================
