// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.2-1 Page 217
//Title: Length of tube for cooling coil
//================================================
model Ex4_2_1

//===============
// Libraries 
extends Modelica.Constants;

//=================
//Parameter section
parameter Real r1(unit = "m") = 0.005 "Inner radius of the cylinder";
parameter Real r2(unit = "m") = 0.02 "Outer radius of the cylinder";
parameter Real l(unit = "m") = 1 "Length of the tube";
parameter Real k(unit = "W/m.K") = 0.151 "Thermal conductivity of the tube";
parameter Real T1(unit = "K") = 274.9 "Inside temperature of the wall";
parameter Real T2(unit = "K") = 297.1 "Outside temperature of the wall";
parameter Real Q_R(unit = "W") = 14.65 "Amount of heat required to be removed";

//=================
//Variable section
Real A1(unit = "m^2") "Inner area of cylinder";
Real A2(unit = "m^2") "Outer area of cylinder";
Real Alm(unit = "m^2") "Logrithmic mean area";
Real q(unit = "W/m") "Total heat transfer";
Real L(unit = "m") "Length of tube of cooling coil";

//=================
//Equation section
equation
A1 = 2*pi*r1*l ; // Inner area
A2 = 2*pi*r2*l ; // Outer area
Alm = (A1-A2)/(log(A1/A2)) ; // Logrithmic mean area
q = k*Alm*(T1-T2)/(r2-r1) ; // Total heat transfer
L = -Q_R/q ; // Length required for cooling
end Ex4_2_1;
//=======================================================
