// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.3-3 Page 228
//Title: Heat loss by convection and conduction and overall U
//================================================
model Ex4_3_3

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real ri(unit = "ft") = 0.412/12 "Inner radius of the cylinder";
parameter Real r1(unit = "ft") = 0.525/12 "Middle radius of the cylinder";
parameter Real ro(unit = "ft") = 2.025/12 "Outer radius of the cylinder";
parameter Real l(unit = "ft") = 1 "Length of the cylinder";
parameter Real kA(unit = "btu/h.ft.F") = 26 "Thermal conductivity of A";
parameter Real kB(unit = "btu/h.ft.F") = 0.037 "Thermal conductivity of B";
parameter Real hi(unit = "btu/h.ft^2.F") = 1000 "Inside heat transfer coefficient";
parameter Real ho(unit = "btu/h.ft^2.F") = 2 "Outside heat transfer coefficient";
parameter Real T1(unit = "F") = 267 "Inside temperature of the wall";
parameter Real T2(unit = "F") = 80 "Outside temperature of the wall";

//================
//Variable section
Real Ai(unit = "ft^2") "Inner area of cylinder";
Real A1(unit = "ft^2") "Middle area of cylinder";
Real Ao(unit = "ft^2") "Outer area of cylinder";
Real Alm1(unit = "ft^2") "Logrithmic mean area 1";
Real Alm2(unit = "ft^2") "Logrithmic mean area 2";
Real q(unit = "btu/h") "Amount of heat transferred";
Real U(unit = "btu/h.ft^2.F") "Overall heat transfer";

//===============
//Equation section
equation
Ai = 2*pi*ri*l ; // Inner area
A1 = 2*pi*r1*l ; // Middle area
Ao = 2*pi*ro*l ; // Outer area
Alm1 = (A1-Ai)/(log(A1/Ai)) ; // Logrithmic mean area
Alm2 = (Ao-A1)/(log(Ao/A1)) ; // Logrithmic mean area
q = (T1-T2)/((1/(hi*Ai))+((r1-ri)/(kA*Alm1))+((ro-r1)/(kB*Alm2))+(1/(ho*Ao))) ; // Total heat transferred
U = 1/(Ai*((1/(hi*Ai))+((r1-ri)/(kA*Alm1))+((ro-r1)/(kB*Alm2))+(1/(ho*Ao)))) ; // Overall heat transfer coefficient
end Ex4_3_3;
//===========================================================
