// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.3-4 Page 231
//Title: Heat generation in a cylinder
//================================================
model Ex4_3_4

//===============
// Libraries 
extends Modelica.Constants;

//================
//Parameter section
parameter Real I(unit = "A") = 200 "Electric current";
parameter Real R(unit = "m") = 0.001268 "Steel having radius R";
parameter Real Res(unit = "ohm") = 0.126 "Resistance in the cylinder";
parameter Real L(unit = "m") = 0.91 "The length of the wire";
parameter Real k(unit = "W/m.K") = 22.5 "Thermal conductivity of the material";
parameter Real Tw(unit = "K") = 422.1 "Tube wall temperature";

//================
//Variable section
Real q(unit = "W/m^3") "Amount of heat transferred";
Real To(unit = "K") "Temperature at the center";

//================
//Equation section
equation
I^2*Res = q*pi*R^2*L ; // Heat generated in the cylinder
To = q*R^2/(4*k) + Tw ; // Temperature at the center of cylinder
end Ex4_3_4;
//================================================
