// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.7-2 Page 257
//Title: Natural convection and simplified equation
//================================================
model Ex4_7_2

//===============
//Parameter section
parameter Real L(unit = "m") = 0.305 "Length of the pipe";
parameter Real Tb(unit = "C") = 311 "Outlet temperature of air";
parameter Real Tw(unit = "K") = 505.4 "Surface temperature";

//===============
//Variable section
Real h(unit = "W/m^2.K") "Heat transfer coefficient";
Real q(unit = "W") "Actual heat transferred";

//===============
//Equation section
equation
h = 1.37*((Tw-Tb)/L)^0.25 ; // Heat transfer coefficient
q = h*L^2*(Tw-Tb) ; // Total heat transfer
end Ex4_7_2;
//================================================
