// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.7-3 Page 258
//Title: Natural convection in a enclosed vertical space 
//================================================
model Ex4_7_3

//================
//Parameter section
parameter Real L(unit = "m") = 0.6 "Length of the pipe";
parameter Real w(unit = "m") = 0.4 "width between pipes";
parameter Real del(unit = "m") = 0.03 "Plate thickness";
parameter Real T1(unit = "C") = 394.3 "Outlet temperature of air";
parameter Real T2(unit = "K") = 366.5 "Surface temperature";
parameter Real rho(unit = "kg/m^3") = 0.9295 "Density of the air";
parameter Real mu(unit = "Pa.s") = 2.21E-05 "Viscosity of the air";
parameter Real k(unit = "W/m.K") = 0.03219 "Thermal conductivity of the pipe";
parameter Real Npr(unit = "-") = 0.693 "Prandle number of the fluid";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//================
//Variable section
Real Tf(unit = "C") "Film temperature";
Real NGr(unit = "-") "Grashoff number";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";
Real q(unit = "W") "Actual heat transferred";
Real beta(unit = "K^-1") "Volumetric coefficient of expansion";

//================
//Equation section
equation
Tf = (T1+T2)/2 ; // Film temperature
beta = 1/Tf ; // Volumetric coefficient of expansion
NGr = del^3*rho^2*g*beta*(T1-T2)/(mu^2) ; // Grashoff number
h = (k/del)*(0.2*(NGr*Npr)^0.25)/(L/del)^(1/9) ; // Heat transfer coefficient
q = h*L*w*(T1-T2) ; // Total heat transfer
end Ex4_7_3;
//==============================================
