// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.8-2 Page 265
//Title: Condensation on vertical tubes 
//================================================
model Ex4_8_2

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real D(unit = "m") = 0.0254 "Diameter of the pipe";
parameter Real rho_l(unit = "kg/m^3") = 966.7 "Density of the condensate";
parameter Real rho_v(unit = "kg/m^3") = 0.391 "Density of the condensate vapor";
parameter Real mu(unit = "Pa.s") = 3.24E-04 "Viscosity of the condensate";
parameter Real k(unit = "W/m.K") = 0.675 "Thermal conductivity of air";
parameter Real L(unit = "m") = 0.305 "Length of the tube";
parameter Real hfg(unit = "kJ/kg") = 2283.2 "Latent heat of vaporisation";
parameter Real g(unit = "m/s^2") = 9.806 "Acceleration due to gravity";
parameter Real Tsat(unit = "C") = 89.44 "Saturation temperature at given pressure";
parameter Real Tw(unit = "C") = 86.11 "Tube wall temperature";

//===============
//Variable section
Real Tf(unit = "C") "Film temperature";
Real NNu(unit = "-") "Nusselt number";
Real A(unit = "m^2") "Area required for condensation";
Real m(unit = "kg/s") "Mass flow rate of the condensate";
Real NRe(unit = "-") "Reynolds number of the fluid";
Real h(unit = "W/m^2.K") "Heat transfer coefficient";

//================
//Equation section
equation
Tf = (Tsat+Tw)/2 ; // Film temperature
NNu = 1.13*((rho_l^2*g*hfg*1000*L^3)/(mu*k*(Tsat-Tw)))^0.25 ; // Nusselt number";
h*L/k = NNu ; // Heat transfer coefficient
A = pi*D*L ; //Surface area of the tube
h*A*(Tsat-Tw) = hfg*1000*m ; // Mass flow rate
NRe = 4*m/(pi*D*mu) ; // Reynols number of the fluid
end Ex4_8_2;
//===========================================================
