// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-4: Principles of steady state heat transfer
//Example 4.9-1 Page 271
//Title: Temperature correction factor for a heat exchanger 
//================================================
model Ex4_9_1

//================
//Parameter section
parameter Real Th1(unit = "C") = 115.6 "Inlet temperature of hot fluid";
parameter Real Th2(unit = "C") = 48.9 "Exit temperature of hot fluid";
parameter Real Tc1(unit = "C") = 21.1 "Inlet temperature of cold fluid";
parameter Real Tc2(unit = "C") = 54.4 "Exit temperature of cold fluid";
parameter Real Cph(unit = "kJ/kg.K") = 2.30 "Specific heat capacity of hot fluid";
parameter Real Cpc(unit = "kJ/kg.K") = 4.187 "Specific heat capacity of cold fluid";
parameter Real mc(unit = "kg/s") = 2.52 "Mass fow rate of cold fluid";
parameter Real A1(unit = "m^2") = 9.30 "Area required for heat transfer";

//================
//Variable section
Real Y(unit = "-") "Correction factor";
Real Z(unit = "-") "Correction factor";
Real LMTD1(unit = "C") "Logarithmic mean temperature difference";
Real LMTD2(unit = "C") "Logarithmic mean temperature difference";
Real U(unit = "W/m^2.K")  "Overall heat transfer coefficient";
Real q(unit = "W") "Actual heat transfer";

//================
//Equation section
equation
q = mc*Cpc*1000*(Tc2-Tc1) ; // Total heat transferred
Z = (Th1-Th2)/(Tc2-Tc1) ; // Correction factor for LMTD
Y = (Tc2-Tc1)/(Th1-Tc1) ; // Correction factor for LMTD
 // For the value of Y and Z the correction factor is 0.74
LMTD1 = 0.74*((Th1-Tc2) - (Th2-Tc1))/(log((Th1-Tc2)/(Th2-Tc1))) ; // LMTD 1
 // Ft=0.74 from figure 4.9.4-a, page : 270
U = q/(A1*LMTD1) ; // Overall heat transfer coefficient
 // For 2-4 heat exchanger Ft=0.94 from figure 4.9.4-b, page : 270
LMTD2 = 0.74*LMTD1 ; // For 2-4 heat exchanger
end Ex4_9_1;
 // The answer obtained is varying from that of book answer
 // The value of 'q' is wrong in the book
//=========================================================
