// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-2-2 Page:334
//Title: Total amount of heat in cooling
//================================================
model Ex5_2_2

//===============
// Libraries 
extends Modelica.Constants;

//==============
//Parameter section
parameter Real r(unit = "mm") = 25.4 "Radius of steel ball";
parameter Real h(unit = "W/m^2.K") = 11.36 "Heat transfer coefficient";
parameter Real To(unit = "K") = 699.9 "Uniform temperature of surface";
parameter Real T_inf(unit = "K") = 394.3 "Constant temparature";
parameter Real t(unit = "hr") = 1 "Time required for cooling";
parameter Real k(unit = "W/m.K") = 43.3 "Thermal conductivity of the solid";
parameter Real Cp(unit = "kJ/kg.K") = 0.4606 "Specific heat capacity";
parameter Real rho(unit = "kg/m^3") = 7849 "Density of solid ball";

//=============
//Variable section
Real x1(unit = "m") "Characterstic length of sphere";
Real NBi(unit = "-") "Biot number of the sphere";
Real e_term(unit = "hr-1") "Lumped thermal capacity of the solid";
Real V(unit = "m^3") "Volume of the sphere";
Real Q(unit = "J") "Amount of heat required for cooling";

//===============
//Equation section
equation
x1 = r/(1000*3) ; // Characterstic length of sphere
 // r is divided by 1000 to convert mm to m
NBi = h*x1/k ; // Biot number of the sphere
V = (4/3)*pi*(r/1000)^3 ; // Volume of vessel
e_term = h/(Cp*1000*rho*x1) ; // Exponential term is thermal capcity of solid
Q = Cp*1000*rho*V*(To - T_inf)*(1-exp(-e_term*3600)); // Heat required for cooling
 // 3600 is divided to convert h to s
 // Cp is multiplied by 1000 to convert kJ to J
end Ex5_2_2;
//===================================================
