// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-5 Principles of Unsteady State Heat transfer
//Example 5-5-1 Page:361
//Title: Chilling dressed beef
//================================================
model Ex5_5_1

//===============
//Parameter section
parameter Real x(unit = "m") = 0 "Center of the slab";
parameter Real rho(unit = "kg/m^3") = 1073 "Density of the beef";
parameter Real Cp(unit = "kJ/kg.K") = 3.48 "Specific heat capacity";
parameter Real k(unit = "W/m.K") = 0.498 "Thermal conductivity of the beef";
parameter Real h(unit = "W/m^2.K") = 39.7 "Heat transfer coefficient";
parameter Real To(unit = "C") = 37.8 "Initial temperature of the beef";
parameter Real T1(unit = "C") = 1.7 "Chilling temperature";
parameter Real thick(unit = "m") = 0.203 "Thickness of slab containing beef";
parameter Real T(unit = "C") = 10 "Center temperature";

//==============
//Variable section
Real alpha(unit = "m^2/s") "Thermal diffusivity of beef";
Real x1(unit = "m") "Half thikness of slab";
Real n(unit = "-") "For the center of slab";
Real m(unit = "-") "Unsteady state term";
Real Y(unit = "-") "Ratio of temperatures";
Real t(unit = "s") "Time required for chilling";

//===============
//Equation section
equation
alpha = k/(rho*Cp*1000) ; // Thermal diffusivity of the solid
x1 = thick/2 ; // Half the thickness of slab
n = x/x1 ; // For the center of the slab
m = k/(h*x1) ; // Unsteady term
Y = (T1-T)/(T1-To) ; // Ratio of temperatures
 // From the graph the corresponding value of X for flat large plate is 0.9, figur 5.3-6, page:341
0.9 = alpha*t/x1^2 ; // Time required for chilling beef
end Ex5_5_1;
//===========================================================
