// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_2_2 Page:389
//Title: Diffusion of water through stagnent, non diffusing air
//================================================
model Ex6_2_2

//==============
//Parameter section
parameter Real pa1(unit = "atm") = 0.0231 "Partial pressure of A at the point 1";
parameter Real pa2(unit = "atm") = 0 "Partial pressure of A at the point 2";
parameter Real p(unit = "atm") = 1 "Total system pressure";
parameter Real delz(unit = "m") = 0.1524 "Distance between the two points";
parameter Real Da(unit = "m^2/s") = 0.25E-04 "Diffusivity of the component A";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314.3 "Universal gas constant";
parameter Real T(unit = "K") = 293 "Temperature at which diffusion takes place"; 

//==============
//Variable section
Real Na(unit = "kmol/m^2.s") "Flux of the component A";
Real pb1(unit = "atm") "Partial pressure of B at point 1";
Real pb2(unit = "atm") "Partial pressure of B at point 2";
Real pbln(unit = "atm") "Logrethmic average of partial pressures";

//==============
//Equation section
equation
pb1 = p - pa1 ; // Partial pressure of B at point 1
pb2 = p - pa2 ; // Partial pressure of B at point 2
pbln = (pb2 - pb1)/(log(pb2/pb1)) ; // Logrithmic average of partial pressures
Na = Da*p*101325*(pa1*101325 - pa2*101325)/(R*T*delz*pbln*101325) ; // Mass transfer flux of A
  //101325 is multiplied to convert atm to Pa
end Ex6_2_2;
//==========================================================
