// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_3_2 Page:402
//Title: Prediction of liquid diffusivity
//================================================
model Ex6_3_2

//==============
//Parameter section
parameter Real mu1(unit = "Pa.s") = 0.8937E-03 "Viscosity at 298 K";
parameter Real mu2(unit = "Pa.s") = 0.5459E-03 "Viscosity at 323 K";
parameter Real VA(unit = "m^3/kmol") = 0.074 "Atomic and molecular volumes";
parameter Real MB(unit = "kg/kmol") = 18.02 "Molecular weight of B";
parameter Real phi(unit = "-") = 2.6 "Molar volume";
parameter Real T1(unit = "K") = 298 "Temperature 1";
parameter Real T2(unit = "K") = 323 "Temperature 2";

//==============
//Variable section
Real Da1(unit = "m^2/s") "Diffusivity at 298 K";
Real Da2(unit = "m^2/s") "Diffusivity at 323 K";

//=============
//Equation section
equation
Da1 = 1.173E-16*(MB*phi)^0.5*T1/(mu1*VA^0.6) ; // Diffusivity at temperature 1
Da2 = 1.173E-16*(MB*phi)^0.5*T2/(mu2*VA^0.6) ; // Diffusivity at temperature 1
end Ex6_3_2;
//===================================================
