// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_4_1 Page:405
//Title: Prediction of diffusivity of albumin
//================================================
model Ex6_4_1

//============
//Parameter section
parameter Real mu(unit = "Pa.s") = 0.8937E-03 "Viscosity at 298 K";
parameter Real MB(unit = "kg/kmol") = 67500 "Molecular weight";
parameter Real T(unit = "K") = 298 "Temperature 1";

//============
//Variable section
Real Da(unit = "m^2/s") "Diffusivity of albumin";

//=============
//Equation section
equation
Da = (9.40E-15*T)/(mu*MB^(1/3)) ; // Diffusivity of albumin
end Ex6_4_1;
//=================================================
