// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_5_1 Page:409
//Title: Diffusion of H2 to through neoprene memberane
//================================================
model Ex6_5_1

//=============
//Parameter section
parameter Real S(unit = "m^3") = 0.051 "Solublity of the gas";
parameter Real pa(unit = "atm") = 0.01 "Partial pressure of hydrogen";
parameter Real Da(unit = "m^2/s") = 1.03E-10 "Diffusivity of the memberane";
parameter Real ca2(unit = "kmol/m^3") = 0 "Concentration at the other side of the memberane";
parameter Real delz(unit = "mm") = 0.5 "Thickness of the memberane";

//=============
//Variable section
Real ca1(unit = "kmol/m^3") "Initial concentration";
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";

//==============
//Equation section
equation
ca1 = S*pa/22.414 ; // Inita concentration of H2
Na = Da*(ca1 - ca2)/(delz/1000) ; // Mass transfer flux
end Ex6_5_1;
//================================================
