// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_5_3 Page:412
//Title: Diffusion of KCl through porous silica
//================================================
model Ex6_5_3

//==============
//Parameter section
parameter Real epslon(unit = "-") = 0.3 "Void fraction of silica";
parameter Real tau(unit = "-") = 4 "Torturosity of the medium";
parameter Real Da(unit = "m^2/s") = 1.87E-09 "Diffusivity of KCl";
parameter Real ca1(unit = "kmol/m^3") = 0.1 "Initial concentration";
parameter Real ca2(unit = "kmol/m^3") = 0 "Final concentration";
parameter Real delz(unit = "mm") = 2 "Thickness of the silica memberane";

//==============
//Variable section
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";

//==============
//Equation section
equation
Na = epslon*Da*(ca1 - ca2)/(tau*(delz/1000)) ; // Mass transfer flux
 // z is divided by 1000 to convert mm to m
end Ex6_5_3;
//===============================================
