// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_3_1 Page:443
//Title: Mass transfer inside a tube
//================================================
model Ex7_3_1

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real cao(unit = "kmol/m^3") = 0 "Initial concentration";
parameter Real D(unit = "mm") = 20 "Diameter of the tube";
parameter Real v(unit = "m/s") = 0.8 "Velocity of the fluid";
parameter Real L(unit = "m") = 1.10 "Length of the tube";
parameter Real pai(unit = "Pa") = 74 "Partial pressure of A at the point 1";
parameter Real Da(unit = "m^2/s") = 6.92E-06 "Diffusivity of the component A";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314.3 "Universal gas constant";
parameter Real T(unit = "K") = 318 "Temperature at which diffusion takes place";
parameter Real mu(unit = "Pa.s") = 1.932E-05 "Viscosity of the fluid";
parameter Real rho(unit = "kg/m^3") = 1.114 "Density of the fluid";

//===============
//Variable section
Real NSc(unit = "-") "Schmit number";
Real NRe(unit = "-") "Reynolds number";
Real pdt(unit = "-") "Product of the two";
Real cai(unit = "kmol/m^3") "Concentration of A at interface";
Real ca(unit = "kmol/m^3") "Concentration at the given length";

//===============
//Equation section
equation
cai = pai/(R*T) ; // Interface concentration
NSc = mu/(rho*Da) ; // Schmit number of the fluid
NRe = D*v*rho/(mu*1000) ; // Reynolds number of the fluid
pdt = NSc*NRe*(D/L)*(pi/4) ; // Product of the both
 // For the above value the ratio of concentration is 0.55
0.55 = (ca - cao)/(cai - cao) ; // Final concentration
end Ex7_3_1;
//============================================================
