// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_4_1 Page:446
//Title: Mass transfer from air bubbles in fermentation
//================================================
model Ex7_4_1

//===============
//Parameter section
parameter Real D(unit = "m") = 1E-04 "Diameter of the tube";
parameter Real Da(unit = "m^2/s") = 3.25E-09 "Diffusivity of the component A";
parameter Real mu(unit = "Pa.s") = 6.947E-04 "Viscosity of the fluid";
parameter Real rho_c(unit = "kg/m^3") = 994 "Density of water";
parameter Real rho_p(unit = "kg/m^3") = 1.113 "Density of the fluid";
parameter Real cao(unit = "kmol/m^3") = 2.26E-04 "Initial concentration of the plate";
parameter Real cai(unit = "kmol/m^3") = 0 "Final concentration";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";

//===============
//Variable section
Real Nsc(unit = "-") "Schmit number";
Real Del_rho(unit = "-") "Difference in density";
Real kL(unit = "m/s") "Mass transfer coefficient of liquid phase";
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";

//================
//Equation section
equation
Nsc = mu/(rho_c*Da) ; // Schmit number of the fluid
Del_rho = rho_c - rho_p ; // Difference in density
kL = 2*(Da/D)+0.31*Nsc^(-2/3)*(Del_rho*mu*g/(rho_c^2))^(1/3) ; // Mass transfer coefficient
Na = kL*(cao - cai) ; // Mass transfer flux
end Ex7_4_1;
//======================================================
