// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_5_2 Page:457
//Title: Diffusion and chemical reaction at boundary
//================================================
model Ex7_5_2

//===============
//Parameter section
parameter Real P(unit = "kPa") = 101.325 "Total system pressure";
parameter Real pa1(unit = "kPa") = 101.325 "Partial pressure at 1";
parameter Real pa2(unit = "kPa") = 0 "Partial pressure at 2";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314.3 "Universal gas constant";
parameter Real T(unit = "K") = 300 "Temperature at which diffusion takes place";
parameter Real Da(unit = "m^2/s") = 0.15E-04 "Diffusivity of the chemical";
parameter Real del(unit = "m") = 2E-03 "Distance between two planes";
parameter Real kl(unit = "m/s") = 5.63E-03 "Mass transfer coefficient";

//===============
//Variable section
Real xa1(unit = "-") "Mole fraction of liquid at 1";
Real xa2(unit = "-") "Mole fraction of liquid at 2";
Real xa2_2(unit = "-") "Mole fraction of liquid at 2 in case 2";
Real c(unit = "kmol/m^3") "Concentration of liquid";
Real Na1(unit = "kmol/m^2.s") "Mass transfer flux for case 1";
Real Na2(unit = "kmol/m^2.s") "Mass transfer flux for case 2";

//================
//Equation section
equation
xa1 = pa1/P ; // Mole fraction at 1, The partial pressure is equal to total pressure
xa2 = pa2/P ; // Mole fraction at 2
c = P*1000/(R*T) ; // Initial concentration of the system
 // P is multiplied by 1000 to convert kPa to Pa
Na1 = (c*Da/del)*log((1+xa1)/(1+xa2)) ; // Mass transfer flux
xa2_2 = Na2/(kl*c) ; // Mole fraction at 2
Na2 = (c*Da/del)*log((1+xa1)/(1+xa2_2)) ; // Mass transfer flux
end Ex7_5_2;
//===========================================================
