// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_6_1 Page:463
//Title: Knudsen diffusivity of H2
//================================================
model Ex7_6_1

//================
//Parameter section
parameter Real r(unit = "A") = 60 "The pore radius";
parameter Real T(unit = "K") = 373 "Temerature of the diffusion";
parameter Real Ma(unit = "kg/kmol") = 2.016 "Molecular weight of the hydrogen";

//===============
//Variable section
Real Dak(unit = "m^2/s") "Knudsen diffusivity";

//=================
//Equation section
equation
Dak = 97*(r/10^10)*(T/Ma)^0.5 ; // Knudsen diffusivity
 // r is divided by 10^10 to convert A to m
end Ex7_6_1;
//==============================================
