// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-8:Evaporation
//Example 8.4-1 Page 498
//Title: Heat transfer area in single effect evaporator
//================================================
model Ex8_4_1

//============
//Parameter section
parameter Real F(unit = "kg/hr") = 9072 "Feed flow rate";
parameter Real xf(unit = "-") = 0.01 "Mass fraction of feed";
parameter Real xv(unit = "-") = 0 "Mass fraction of vapor";
parameter Real xl(unit = "-") = 0.015 "Mass flow rate of vapor";
parameter Real Cpf(unit = "kJ/kg.K") = 4.14 "Heat capacity of feed";
parameter Real T1(unit = "K") = 373.2 "Datum temperature";
parameter Real Ts(unit = "K") = 383.2 "Saturation temperature of steam";
parameter Real Tf(unit = "K") = 311 "Feed temperature";
parameter Real lamda(unit = "kJ/kg") = 2230 "Latent heat of vaporisation at saturation temperature";
parameter Real Hv(unit = "kJ/kg") = 2257 "Latent heat of water at 373 K";
parameter Real Hl(unit = "kJ/kg") = 0 "Latent heat at datum temperature";
parameter Real U(unit = "W/m^2.K") = 1704 "Overall heat transfer area";

//============
//Variable section
Real L(unit = "kg/hr") "Flow rate of liquid";
Real V(unit = "kg/hr") "Flow rate of vapor";
Real S(unit = "kg/hr") "Mass flow rate of steam";
Real q(unit = "W") "Heat transfered through surface area";
Real A(unit = "m^2") "Area required for heat transfer";

//============
//Equation section
equation
F = L + V ; // Material balance equation
F*xf = L*xl + V*xv ; // Component balance
F*Cpf*(Tf-T1) + S*lamda = L*Hl + V*Hv ; // Mass flow rate of steam
q = S*lamda*1000/3600 ; // Heat transferred
  // Lamda is multiplied by 1000 to convert kJ to J
  // It is divided by 3600 to convert hr to s
q = U*A*(Ts-T1) ; // Overall heat transfer area
end Ex8_4_1;
//===================================================
