// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-8:Evaporation
//Example 8.4-3 Page 501
//Title: Evaporation of NaOH Solution
//================================================
model Ex8_4_3

//============
//Parameter section
parameter Real F(unit = "kg/hr") = 4536 "Feed flow rate";
parameter Real xf(unit = "-") = 0.2 "Mass fraction of feed";
parameter Real xv(unit = "-") = 0 "Mass fraction of vapor";
parameter Real xl(unit = "-") = 0.5 "Mass flow rate of vapor";
parameter Real Hf(unit = "kJ/kg") = 214 "Heat capacity of feed";
parameter Real T1(unit = "C") = 89.5 "Boiling point of solution";
parameter Real Tf(unit = "C") = 60 "Feed temperature";
parameter Real Tb(unit = "C") = 48.9 "Temperature at given vapor space pressure";
parameter Real Ts(unit = "C") = 115.6 "Steam temperature at 172.4 Kpa";
parameter Real lamda(unit = "kJ/kg") = 2214 "Latent heat of vaporisation from steam tables";
parameter Real Hv(unit = "kJ/kg") = 2667 "Latent heat of water at 373 K";
parameter Real Hl(unit = "kJ/kg") = 505 "Latent heat at datum temperature";
parameter Real U(unit = "W/m^2.K") = 1560 "Overall heat transfer area";

//============
//Variable section
Real L(unit = "kg/hr") "Flow rate of liquid";
Real V(unit = "kg/hr") "Flow rate of vapor";
Real S(unit = "kg/hr") "Mass flow rate of steam";
Real q(unit = "kW") "Heat transfered through surface area";
Real A(unit = "m^2") "Area required for heat transfer";
Real BPR(unit = "C") "Boiling point rise";
Real s_eco(unit = "-") "Steam economy";

//============
//Equation section
equation
F = L + V ; // Material balance equation
F*xf = L*xl + V*xv ; // Component balance
F*Hf + S*lamda = L*Hl + V*Hv ; // Mass flow rate of steam
q = S*lamda*(1/3600) ; // Heat transferred through the area
BPR = T1-Tb ; // Boiling point rise
q*1000 = U*A*(Ts - T1) ; // Area required
s_eco = V/S ; // Steam economy
end Ex8_4_3;
//==========================================
