// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-8:Evaporation
//Example 8.5-1 Page 505
//Title: Evaporation of Sugar Solution in a triple effect evaporator
//================================================
model Ex8_5_1

//==============
//Parameter section
parameter Real F(unit = "kg/hr") = 22680 "Mass flow rate of feed";
parameter Real xf(unit = "-") = 0.1 "Mass fraction of solute in feed";
parameter Real xv(unit = "-") = 0 "Mass fraction of solute in vapor";
parameter Real x3(unit = "-") = 0.5 "Final mass fraction of solute desired";
parameter Real Tsat(unit = "C") = 51.67 "Temperature of vapor space in effect 3 at the pressure";
parameter Real TS1(unit = "C") = 121.1 "Feed temperature of steam";
parameter Real Tf(unit = "C") = 26.7 "Feed temperature of solution";
parameter Real U1(unit = "C") = 3123 "Overall Heat transfer coeffecient in effect 1";
parameter Real U2(unit = "C") = 1987 "Overall Heat transfer coeffecient in effect 2";
parameter Real U3(unit = "C") = 1136 "Overall Heat transfer coeffecient in effect 3";
parameter Real HS1(unit = "kJ/kg") = 2708 "Vapor saturation enthalpy";
parameter Real HS2(unit = "kJ/kg") = 2684 "Enthalpy of steam at TS2";
parameter Real HS3(unit = "kJ/kg") = 2654 "Enthalpy of steam at TS3";
parameter Real HS4(unit = "kJ/kg") = 2595 "Enthalpy of steam at TS4";
parameter Real hs1(unit = "kJ/kg") = 508 "Liquid enthalpy at TS1";
parameter Real hs2(unit = "kJ/kg") = 441 "Liquid enthalpy at TS1";
parameter Real hs3(unit = "kJ/kg") = 361 "Liquid enthalpy at TS1";

//=============
//Variable section
Real BPR1(unit = "C") "Boiling point of rise 1st effect";
Real BPR2(unit = "C") "Boiling point of rise 2nd effect";
Real BPR3(unit = "C") "Boiling point of rise 3rd effect";
Real v1(unit = "kg/hr") "Vapor flow rate in 1st effect";
Real v2(unit = "kg/hr") "Vapor flow rate in 2nd effect";
Real v3(unit = "kg/hr") "Vapor flow rate in 3rd effect";
Real L1(unit = "kg/hr") "Liquid flow rate in 1st effect";
Real L2(unit = "kg/hr") "Liquid flow rate in 2nd effect";
Real L3(unit = "kg/hr") "Liquid flow rate in 3rd effect";
Real V(unit = "kg/hr") "Total vapor flow rate";
Real x1(unit = "-") "Mass fraction of solute after effect 1";
Real x2(unit = "-") "Mass fraction of solute after effect 2";
Real T3(unit = "C") "Teperature after boiling point rise";
Real DelT_avail(unit = "C") "Overall temperature difference";
Real DelT1(unit = "C") "Temperature difference in effect 1";
Real DelT2(unit = "C") "Temperature difference in effect 2";
Real DelT3(unit = "C") "Temperature difference in effect 3";
Real T1(unit = "C") "Actual Boiling point in effect 1";
Real T2(unit = "C") "Actual Boiling point in effect 2";
Real TS2(unit = "C") "Stream temperature in effect 2";
Real TS3(unit = "C") "Stream temperature in effect 3";
Real Cpf(unit = "kJ/kg.K") "Specific heat capacity of feed";
Real Cp1(unit = "kJ/kg.K") "Specific heat capacity of stage 1";
Real Cp2(unit = "kJ/kg.K") "Specific heat capacity of stage 2";
Real Cp3(unit = "kJ/kg.K") "Specific heat capacity of stage 3";
Real H1(unit = "kJ/kg") "Enthalpy of the fluid at effect 1";
Real lamda_s1(unit = "kJ/kg") "Latent heat of condensation";
Real H2(unit = "kJ/kg") "Enthalpy of the fluid at effect 2";
Real lamda_s2(unit = "kJ/kg") "Latent heat of condensation";
Real H3(unit = "kJ/kg") "Enthalpy of the fluid at effect 3";
Real lamda_s3(unit = "kJ/kg") "Latent heat of condensation";
Real S(unit = "kg/hr") "Mass flow rate of steam";
Real L_1(unit = "kg/hr") "Liquid flow rate in 1st effect";
Real L_2(unit = "kg/hr") "Liquid flow rate in 2nd effect";
Real v_1(unit = "kg/hr") "Vapor flow rate in 1st effect";
Real v_2(unit = "kg/hr") "Vapor flow rate in 2nd effect";
Real v_3(unit = "kg/hr") "Vapor flow rate in 3rd effect";
Real q1(unit = "W") "Heat transferred in effect 1";
Real q2(unit = "W") "Heat transferred in effect 2";
Real q3(unit = "W") "Heat transferred in effect 3";
Real A1(unit = "m^2") "Area required for effect 1";
Real A2(unit = "m^2") "Area required for effect 2";
Real A3(unit = "m^2") "Area required for effect 3";
Real Aavg(unit = "m^2") "Average area required";
Real steam_eco(unit = "-") "Steam economy";

//==============
//Equation section
equation
BPR3 = 1.78*x3 + 6.22*x3^2 ; // Boiling point rise in 3rd effect
T3 = Tsat + BPR3 ; // Temperature rise due to boiling point rise
F = L3 + V ; // Overall mass balance
F*xf = L3*x3 + V*xv ; // Component balance
V/3 = v1 ; // Indivudal vapor flow rates
v1 = v2; // Vapor flow rate in effect 2
F = v1 + L1 ; // Liquid flow rate in 1st effect
L1 = v2 + L2 ; // Liquid flow rate in 2nd effect
L2 = v3 + L3 ; // Liquid flow rate in 3rd effect
F*xf = L1*x1 ; // Component balance equation
L1*x1 = L2*x2 ; // Component balance equation
BPR1 = 1.78*x1 + 6.22*x1^2 ; // Boiling point rise in 1st effect
BPR2 = 1.78*x2 + 6.22*x2^2 ; // Boiling point rise in 2nd effect
DelT_avail = TS1 - Tsat - (BPR1+BPR2+BPR3) ; // Overall driving force available
DelT1 = DelT_avail*((1/U1)/((1/U1)+(1/U2)+(1/U3))) ; // Driving force in effect 1
DelT2 = DelT_avail*((1/U2)/((1/U1)+(1/U2)+(1/U3))) ; // Driving force in effect 2
DelT3 = DelT_avail*((1/U3)/((1/U1)+(1/U2)+(1/U3))) ; // Driving force in effect 3
T1 = TS1 - DelT1 - 3.16 ; // Actual T1
T2 = TS2 - DelT2 - BPR1 + 1.16 ; // T2 actual
TS2 = T1 - BPR1 ; // New saturation temperature
TS3 = T2 - BPR2 ; // New saturation temperature
Cpf = 4.19 - 2.35*xf ; // Specific heat capacity of feed
Cp1 = 4.19 - 2.35*x1 ; // Specific heat capacity of  stage 1
Cp2 = 4.19 - 2.35*x2 ; // Specific heat capacity of stage 1
Cp3 = 4.19 - 2.35*x3 ; // Specific heat capacity of stage 1
H1 = HS2 + 1.884*BPR1 ; // Ethalpy in stage 1
lamda_s1 = HS1 - hs1 ; // Latent heat in stage 1
H2 = HS3 + 1.884*BPR2 ; // Ethalpy in stage 1
lamda_s2 = H1 - hs2 ; // Ethalpy in stage 1
H3 = HS4 + 1.884*BPR3 ; // Ethalpy in stage 1
lamda_s3 = H2 - hs3 ; // Ethalpy in stage 1
F*Cpf*(Tf - 0) + S*lamda_s1 = L_1*Cp1*(T1 - 0) + (F - L_1)*H1 ; // Energy balance equation for stage 1
L_1*Cp1*(T1 - 0) + (F - L_1)*lamda_s2 = L_2*Cp2*(T2 - 0) + (L_1 - L_2)*H2 ; // Energy balance equation for stage 2
L_2*Cp2*(T2 - 0) + (L_1 - L_2)*lamda_s3 = L3*Cp3*(T3 - 0) + (L_2 - L3)*H3 ; // Energy balance equation for stage 3
F = v_1 + L_1 ; // New vapor flow rates
L_1 = v_2 + L_2 ;
L_2 = v_3 + L3 ;
q1 = S*lamda_s1*(1000/3600) ; // Heat transferred in effect 1
q2 = v_1*lamda_s2*(1000/3600) ; // Heat transferred in effect 2
q3 = v_2*lamda_s3*(1000/3600) ; // Heat transferred in effect 3
  // The value is multiplied by 1000/3600 to convert kJ to J and hr to s
A1 = q1/(U1*(DelT1 + 3.16)) ; // Area required for effect 1
A2 = q2/(U2*(DelT2 - 1.16)) ; // Area required for effect 2
A3 = q3/(U3*(DelT3 - 2)) ; // Area required for effect 3
Aavg = (A1 + A2 + A3)/3 ; // Average area
steam_eco = (v_1 + v_2 + v_3)/S ; // Steam economy
end Ex8_5_1;
//===================================================================
