// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.10-1 Page 559
//Title: Through circulation drying in the bed
//================================================
model Ex9_10_1

//================
//Parameter section
parameter Real d(unit = "mm") = 6.35 "Diamter of the dryer";
parameter Real l(unit = "mm") = 25.4 "Length of thr dryer";
parameter Real x1(unit = "mm") = 50.8 "Thickness of th bed";
parameter Real v(unit = "m/s") = 0.811 "Velocity of the incoming air";
parameter Real epslon_s(unit = "-") = 0.6 "Void fraction of the solid";
parameter Real Xt1(unit = "-") = 1.00 "Initial moisture content";
parameter Real Xtc(unit = "-") = 0.50 "Moisture content at end of constant rate of drying";
parameter Real X_e(unit = "-") = 0.01 "Equilibrium moisture content";
parameter Real Xt(unit = "-") = 0.10"Final moisture content";
parameter Real T(unit = "C") = 121.1 "Temperature of incoming air";
parameter Real Tw(unit = "C") = 47.2 "Wet bulb temperature of incoming air";
parameter Real rho_air(unit = "kg/m^3") = 1 "Density of the air at 25 C";
parameter Real rho_solid(unit = "kg/m^3") = 1602 "Density of the solid";
parameter Real rho_s(unit = "kg/m^3") = 641 "Density of the porous solid medium";
parameter Real mu(unit = "Pa.s") = 2.15E-05 "Viscosity of the incoming air";
parameter Real H1(unit = "kg.water/kg.air") = 0.04 "Humidity of th incomming air";
parameter Real Hw(unit = "kg.water/kg.air") = 0.074 "Humidity at the assumed wet bulb temperature";
parameter Real H_avg(unit = "kg.water/kg.air") = 0.05 "Average humidity assumed";
parameter Real lamda(unit = "kJ/kg.K") = 2389 "Latent heat of vaporisaition at wet bulb temperature";

//================
//Variable section
Real X1(unit = "-") "Free moisture content";
Real Xc(unit = "-") "Critical moisture content";
Real X(unit = "-") "Available moisture content";
Real vH(unit = "m^3/kg") "Humid volume of air";
Real rho(unit = "kg/m^3") "Density of the mixture";
Real G(unit = "kg/h.m^2") "Mass velocity of dry air";
Real G_avg(unit = "kg/h.m^2") "Average Mass velocity of air";
Real a(unit = "m^2") "Surface area of the dryer";
Real Dp(unit = "m") "Equivalent diameter of the dryer";
Real NRe(unit = "-") "Reynolds number for air flow";
Real h(unit = "W/m^2.K") "Heat transfer coefficent of the air";
Real cs(unit = "J/kg") "Specific heat capacity";
Real t1(unit = "s") "Time required for drying in constant rate period";
Real t2(unit = "s") "Time require for drying in falling rate of drying";
Real t(unit = "h") "Total time required for drying";

//================
//Equation section
equation
X1 = Xt1 - X_e ; // Free moisture content
Xc = Xtc - X_e ; // Critical moistre content
X = Xt - X_e ; // Available moisture content
vH = (2.83E-03 + 4.56E-03*H1)*(273 + T) ; // Humid volume of the mixture of air
 // 273 is added to convert C to K
rho = (rho_air + H1)/vH ; // Density of incoming air mixture
G = v*rho*3600*(rho_air/(rho_air + H1)) ; // Mass velocity of the air
 // H average is assumed to be 0.05 which is between Humidity of incoming air and exit air
G_avg = G + G*H_avg ; // Average mass velocity
a = 4*(1-epslon_s)*((l/1000) + 0.5*(d/1000))/((d*l/1000000)) ; //Surface area available for drying
 // 10^-3 and 10^-6 are multiplied correspondingly to convert mm to m
Dp = ((d*l/1000000) + 0.5*(d^2/1000000))^0.5 ; // Diameter of the sphere
NRe = Dp*G_avg/(mu*3600) ; // Viscosity of the incoming air
 // 3600 is multiplied to convert S to h
h = 0.151*(G_avg^0.59/Dp^0.41) ; // Heat transfer coefficient
cs = (1.005 + 1.88 *H_avg)*1000 ; // Specific heat capacity
t1 = rho_s*lamda*x1*(X1 - Xc)/((G/3600)*cs*(T - Tw)*(1-exp((-h*a*(x1/1000))/((G_avg/3600)*cs)))); // Time required for constant rate of drying
t2 = rho_s*lamda*x1*Xc*log(Xc/X)/((G/3600)*cs*(T - Tw)*(1-exp((-h*a*(x1/1000))/((G_avg/3600)*cs)))); // Time required for falling rate of period 
t = (t1 + t2)/3600 ; // Total time required for drying
// 3600 is divided to convert S to h
end Ex9_10_1;
//==========================================================
