// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.3-1 Page 526
//Title: Humidity from vapor pressure data
//================================================
model Ex9_3_1

//=================
//Parameter section
parameter Real pa(unit = "kPa") = 2.76 "Partial pressue";
parameter Real pas(unit = "kPa") = 3.5 "Saturated vapor pressue";
parameter Real P(unit = "kPa") = 101.3 "Total system pressure";
parameter Real Ma(unit = "kg/kmol") = 18.02 "Molecular weight of water";
parameter Real Mb(unit = "kg/kmol") = 28.97 "Molecular weight of air";

//=================
//Varaiable section
Real H(unit = "kg.H2O/kg.dry.air") "Absolute humidity";
Real Hs(unit = "kg.H2O/kg.dry.air") "Saturated humidity";
Real Hp(unit = "-") "Percentage humidity";
Real HR(unit = "-") "Relative humidity";

//=================
//Equation section
equation
H = (Ma/Mb)*(pa/(P-pa)) ; // Absolute humidity
Hs = (Ma/Mb)*(pas/(P-pas)) ; // Saturated humidity
Hp = (H/Hs)*100 ; // Percentage humidity
HR = (pa/pas)*100 ; // Relative humidity
end Ex9_3_1;
//=================================================
