// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.8-1 Page 543
//Title: Constant rate of drying when convection and radiation are present
//================================================
model Ex9_8_1

//================
//Parameter section
parameter Real T(unit = "K") = 366.5 "Hot air inlet temperature";
parameter Real T1(unit = "K") = 338.6 "Surface temperature";
parameter Real hc(unit = "W/m^2.K") = 62.45 "Heat transfer coefficient";
parameter Real Ts_as(unit = "K") = 305.4 "Assumed saturation temperature of leaving air";
parameter Real zs(unit = "m") = 0.0254 "Height of the dryer";
parameter Real zm(unit = "m") = 0.00061 "Thickness of the dryer";
parameter Real km(unit = "W/m.K") = 43.3 "Thermal conductivity of the metal";
parameter Real ks(unit = "W/m.K") = 0.865 "Thermal conductivity of the solid";
parameter Real lamda_s(unit = "kJ/kg.K") = 2423 "Latent heat of vaporisation";
parameter Real epslon(unit = "-") = 0.92 "Emissivity of the material";
parameter Real H(unit = "kg.moisture/kg.air") = 0.010 "Humidity of the incoming air";

//================
//Variable section
Real hR(unit = "W/m^2.K") "Heat transfer coefficient due to radiation";
Real Uk(unit = "W/m^2.K") "Overall heat transfer coefficient";
Real cs(unit = "J/kg.K") "Specific heat capacity";
Real Rc(unit = "kg/h.m^2") "Rate of drying with convection and radiation";

//================
//Equation section
equation
hR = epslon*5.676*((T/100)^4 - (Ts_as/100)^4)/(T - Ts_as) ; // Heat transfer coefficient due to radiation
Uk = 1/((1/hc)+(zm/km)+(zs/ks)) ; // Overall heat transfer coefficient
cs = (1.005 + 1.88*H)*10^3 ; // Specific heat capacity
 // 10^3 is multiplied to convert kJ to J
 // The assumed surface temperature dosent change much so it is taken as 305.8
Rc = ((hc + Uk)*(T1 - 305.8) + hR*(T - 305.8))*3600/(lamda_s*1000) ; 
 // 3600 is multiplied to convert S to h
 // 1000 is multiplied to convert kJ to J
end Ex9_8_1;
//=================================================
